% Pretrazivanje baze slika
% Elektrotehnicki fakultet, Univerzitet u Banjoj Luci, 2014.

% definisi parametre 
conf = get_conf();
load(conf.desc_filename)

% zadati sliku upit
[filename, pathname] = uigetfile({'*.jpg'; '*.*'}, 'Slika upit', pwd);
a = imread([pathname, filename]);
a = im2double(a);

% odrediti deskriptor upita
query = compute_color_histogram(a, conf);

% ucitavanje deskriptora baze
load(conf.desc_filename)

% Pretrazivanje baze. Racuna se udaljenost deskriptora svake slike iz baze
% od deskriptora upita.
dist = compute_histogram_intersection(query, features);

% Sortiranje udaljenosti u rastucem redoslijedu. U nizu sorted su
% sortirane vrijednosti udaljenosti, a u nizu ind su indeksi elemenata u
% originalnom nizu.
[sorted, ind] = sort(dist);

% prikazi rezultate
thumbs(features(ind(1:24)), sorted(1:24), conf);
