%% Klasifikacija rukom pisanih cifara pomocu neuronske mreze
% Primjer prilagodjen iz Machine Learning kursa na coursera.org

%% Inicijalizacija
clear ; close all; clc

%% Parametri
input_layer_size  = 400;  % ulazne slike su 20x20 piksela
hidden_layer_size = 25;   % 25 skrivenih neurona
num_labels = 10;          % 10 oznaka cifara, od 1 do 10   
                          % (cifra "0" je oznacena kao 10)

%% =========== Ucitavanje i vizuelizacija podataka =============

% Ucitavanje podataka
fprintf('Ucitavanje i vizuelizacija podataka ...\n')

load('cifre.mat');
m = size(X, 1);

% Slucajno se bira 100 primjera za prikazivanje
sel = randperm(size(X, 1));
sel = sel(1:100);

displayData(X(sel, :));

fprintf('Program pauziran. Pritisnite neki taster za nastavak.\n');
pause;

%% ================ Ucitavanje modela ================

fprintf('\nUcitavanje sacuvanih tezina neuronske mreze ...\n')

% Tezine se ucitavaju u promjenljive W1 i W2
load('tezine.mat');

%% ================= Klasifikacija =================
%  Vas zadatak je implementacija funkcije predict kojom je realizovana
%  klasifikacija slike
pred = predict(W1, W2, X);

fprintf('\nTacnost na trening skupu: %f\n', mean(double(pred == y)) * 100);

fprintf('Program pauziran. Pritisnite neki taster za nastavak.\n');
pause;

%  Prikazivanje primjera i predikcije koju daje mreza.

%  Slucajna permutacija primjera
rp = randperm(m);

for i = 1:m
    
    displayData(X(rp(i), :));

    pred = predict(W1, W2, X(rp(i),:));
    fprintf('\nPredikcija neuronskom mrezom: %d (cifra %d)\n', pred, mod(pred, 10));
    
    % Pause
    fprintf('Program pauziran. Pritisnite neki taster za nastavak.\n');
    pause;
end

