%% ================ Obucavanje neuronske mreze ================
% Primjer prilagodjen iz Machine Learning kursa na coursera.org

%% Inicijalizacija
clear ; close all; clc

%% =========== Ucitavanje i vizuelizacija podataka =============

% Ucitavanje podataka
fprintf('Ucitavanje i vizuelizacija podataka ...\n')

load('cifre.mat');
m = size(X, 1);

mtrain = 4000;

% Formiranje trening i test skupa
% =============================================================================
% Ovdje ide vas kod. Potrebno je formirati sljedece promjenljive
% Ove inicijalizacije su nepotrebne. Postoje samo da bi se naznacile konacne
% dimenzije matrica i nizova.
Xtrain = zeros(mtrain, size(X, 2));
ytrain = zeros(mtrain, 1);
Xtest = zeros(m - mtrain, size(X, 2));
ytest = zeros(m - mtrain, 1);
% =============================================================================

% parametri mreze
input_layer_size  = 400;  % ulazne slike su 20x20 piksela
hidden_layer_size = 25;   % 25 skrivenih neurona
num_labels = 10;          % 10 oznaka cifara, od 1 do 10   
                          % (cifra "0" je oznacena kao 10)

%  Inicijalizacija tezina neuronske mreze
fprintf('\nInicijalizacija tezina ...\n')

initial_W1 = randInitializeWeights(input_layer_size, hidden_layer_size);
initial_W2 = randInitializeWeights(hidden_layer_size, num_labels);

%  Preuredjivanje parametara zbog sintakse koristene funkcije za
%  optimizaciju
initial_nn_params = [initial_W1(:) ; initial_W2(:)];

%  Obucavanje
fprintf('\nObucavanje neuronske mreze... \n')

%  Maksimalan broj iteracija optimizacionog algoritma
options = optimset('MaxIter', 300);

%  Regularizacioni parametar
lambda = 3;

%  Referenca na funkciju koja se minimizira
costFunction = @(p) nnCostFunction(p, ...
                                   input_layer_size, ...
                                   hidden_layer_size, ...
                                   num_labels, Xtrain, ytrain, lambda);

%  Poziv funkcije za optimizaciju
[nn_params, cost] = fmincg(costFunction, initial_nn_params, options);

%  Raspakovati W1 i W2 iz nn_params
W1 = reshape(nn_params(1:hidden_layer_size * (input_layer_size + 1)), ...
                 hidden_layer_size, (input_layer_size + 1));

W2 = reshape(nn_params((1 + (hidden_layer_size * (input_layer_size + 1))):end), ...
                 num_labels, (hidden_layer_size + 1));

fprintf('Program pauziran. Pritisnite neki taster za nastavak.\n');
pause;

% Testiranje obucene mreze
% Ovdje ide Vas kod koji poziva funkciju predict za trening i test skup.
% ==============================================================================

fprintf('\nTacnost na trening skupu: %f\n', mean(double(pred == ytrain)) * 100);

fprintf('\nTacnost na test skupu: %f\n', mean(double(pred == ytest)) * 100);

% ==============================================================================
