% Izdvajanje deskriptora za BoW klasifikator za aero slike. 
% Prilagodjen demo iz VLFeat

%% parametri

conf = get_conf();

% ucitaj rjecnik
load(conf.codebook_filename);
model.vocab = vocab;
model.kdtree = vl_kdtreebuild(vocab);
clear vocab;

dir_list = dir([conf.images_filepath filesep '*' conf.ext]);
Nimages = length(dir_list);
images = {dir_list.name};

hist = {};
parfor ii = 1:length(images)
    im = im2single(imread([conf.images_filepath filesep images{ii}]));
    [frames, descrs] =  vl_phow(im, 'sizes', conf.size, 'step', conf.step, 'floatdescriptors', true);

    hist{ii} = get_BoW_descriptor(descrs, model);
end

hist = cat(2, hist{:});
save(conf.bow_filename, 'hist', 'images');
