% Formiranje kodne knjige

conf = get_conf();

% formiranje liste slika
dir_list = dir([conf.images_filepath filesep '*' conf.ext]);
Nimages = length(dir_list);

% alokacija memorije za SIFT deskriptore koje cemo klasterizovati
data = zeros(128, conf.num_training_codebook*conf.num_patches, 'single');

kk = 0;
for k = 1:conf.num_training_codebook
%     ii = randi(Nimages, 1);
    ii = ceil(Nimages * rand());
    im = im2single(imread([conf.images_filepath filesep dir_list(ii).name]));
    [frames, descrs] =  vl_phow(im, 'sizes', conf.size, 'step', conf.step, 'floatdescriptors', true);
    data(:, (k-1)*conf.num_patches+1:k*conf.num_patches) = vl_colsubset(descrs, conf.num_patches);
 end

vocab = vl_kmeans(data, conf.num_words, 'verbose', 'algorithm', 'elkan');

save(conf.codebook_filename, 'vocab');

