function score = svm_lin(training_set, test_set, paramC, Ctraining, Nclasses)

score = zeros(size(test_set, 1), Nclasses);

for c = 1:Nclasses
    model = svmtrain(double(Ctraining == c), training_set, ['-c ' num2str(paramC) ' -t 0']);
    [ctest_hat, foo, score(:, c)] = svmpredict(zeros(size(test_set, 1), 1), test_set, model);
    score(:, c) = abs(score(:, c));
    score(ctest_hat == 0, c) = -score(ctest_hat == 0, c);
end
    

