% Formiranje kodne knjige

conf = get_conf();

% formiranje liste slika
dir_list = dir([conf.images_filepath filesep '*' conf.ext]);
Nimages = length(dir_list);

% alokacija memorije za SIFT deskriptore koje cemo klasterizovati
% data = zeros(128, Nimages*conf.num_patches, 'single');
data = cell(1, Nimages);
kk = 0;
for k = 1:Nimages
    im = im2single(imread([conf.images_filepath filesep dir_list(k).name]));
    [frames, descrs] = getFeatures(im, conf.featureOpts{:});
%     num_patches = min(conf.num_patches, size(descrs, 2));
    data{k} = vl_colsubset(descrs, conf.num_patches);
 end
data = cat(2, data{:});
% vocab = vl_kmeans(data, conf.num_words, 'verbose', 'algorithm', 'elkan');
[vocab, kdtree] = annkmeans(data, conf.num_words, ...
                                        'numTrees', 4, ...
                                        'maxNumComparisons', 1024, ...
                                        'maxNumIterations', 30, ...
                                        'tolerance', 1e-3, ...
                                        'verbose', true, ...
                                        'seed', 2) ;
save(conf.codebook_filename, 'vocab', 'kdtree');

