% SVM klasifikacija blokova velicine 128x128 piksela izdvojenih sa
% aerofoto snimka Banje Luke

%% Parameters

categories = {'kuce','groblje','industrija','njiva','rijeka','zelenilo'};
Nclasses = length(categories);

% broj trening slika po klasi
Ntraining_class = 10;

%% Ucitavanje deskriptora

load bl_gabor

features = cell2mat(features);
Nsamples = length(features);
Nfeatures = length(features(1).desc);

% odrediti oznake klasa za sve slike
C = zeros(Nsamples, 1);
for i = 1:Nsamples
    [path, filename] = fileparts(features(i).filename);
    C(i) = strmatch(filename(1), categories);
end

%% klasifikacija se ponavlja N puta (N-fold cross validation)
Nruns = 10;

Cm = zeros(Nclasses, Nclasses, Nruns);
Cm_raw = zeros(Nclasses, Nclasses, Nruns);

for r = 1:Nruns
    % Podjela na trening i test skup
    
    train_ind = [];
    
    for c = 1:Nclasses
        class_ind = find(C == c);
        ii = randperm(length(class_ind));
        train_ind = [train_ind; class_ind(ii(1:Ntraining_class))];
    end
    test_ind = setdiff(1:Nsamples, train_ind);
    training_set = cat(1, features(train_ind).desc);
    test_set = cat(1, features(test_ind).desc);
    
    % Normalizacija
    M = max(training_set);
    m = min(training_set);
    training_set = (training_set - repmat(m, size(training_set, 1), 1)) ./ repmat(M-m, size(training_set, 1), 1);
    test_set = (test_set - repmat(m, size(test_set, 1), 1)) ./ repmat(M-m, size(test_set, 1), 1);
    training_set(isnan(training_set)) = 0;
    test_set(isnan(test_set)) = 0;
    
    % Obucavanje SVM    
    model = svmtrain(C(train_ind), training_set, '-t 2 -g 1e0 -c 1e3');
    
    % Predikcija klase pomocu SVM
    [ctest_hat, acc, scores] = svmpredict(C(test_ind), test_set, model);
    
    % Izracunavanje matrica konfuzija
    for j = 1:Nclasses
        for i = 1:Nclasses
            % red i, kolona j je dio slika iz klase i koje su klasifikovane u
            % klasu j
            Cm(i, j, r) = 100*sum((C(test_ind)==i) .* (ctest_hat==j))/sum(C(test_ind)==i);
            Cm_raw(i, j, r) = sum((C(test_ind)==i) .* (ctest_hat==j));
        end
    end
    
end

figure, imagesc(mean(Cm, 3)); colorbar
colormap(jet)

sss = zeros(Nruns, Nclasses);
for i = 1:Nruns
    sss(i, :) = diag(Cm(:, :, i));
end

fprintf('Macroavg: %.2f(%.2f)%%\n', mean(mean(sss, 2)), std(mean(sss, 2)));

