% Automatsko pretrazivanje Corel 1K baze slika
% Svaka slika je upit i racunaju se precision, recall i MAP.
% Elektrotehnicki fakultet, Univerzitet u Banjoj Luci, 2014.

% definisi parametre 
conf = get_conf();
load(conf.desc_filename)

% racunanje standardne devijacije deskriptora
all_features = cat(1,features{:});
alpha = std(cat(1, all_features.desc));

% inicijalizacija, kolekcija sadrzi 1000 slika
precision = zeros(1000, 1000);
recall = zeros(1000, 1000);
ap = zeros(1000, 1);
rel = zeros(1, 1000);

for k = 1:1000
    % odrediti deskriptor upita
    [foo, filename] = fileparts(features{k}.filename);
    query = features{k}.desc;

    % Pretrazivanje baze. Racuna se udaljenost deskriptora svake slike iz baze
    % od deskriptora upita.
    dist = compute_euclidean_distances(query, features);
%     dist = compute_histogram_intersection(query, features);
%     dist = compute_l1_distances(query, features, alpha);

    % Sortiranje udaljenosti u rastucem redoslijedu. U nizu sorted su
    % sortirane vrijednosti udaljenosti, a u nizu ind su indeksi elemenata u
    % originalnom nizu.
    [sorted, ind] = sort(dist);

    % Odredjivanje relevantnosti slika iz baze za dati upit.
    for m = 1:1000
        [foo, imname] = fileparts(features{ind(m)}.filename);
        rel(m) = floor(str2double(imname)/100) == floor(str2double(filename)/100);
    end
    
    % Izracunavanje P, R i AP
    precision(k, :) = cumsum(rel)./(1:1000);
    recall(k, :) = cumsum(rel)/100;
    ap(k) = sum(precision(k, :) .* rel) / 100;
end

% Izracunavanje MAP
map = mean(ap);

% Crtanje P-R grafika
figure, plot(mean(recall), mean(precision));
xlabel('Recall'); ylabel('Precision'); title(['MAP = ' num2str(map)]);

