% Automatsko pretrazivanje Corel 1K baze slika
% Svaka slika je upit i racunaju se precision, recall i MAP.
% Elektrotehnicki fakultet, Univerzitet u Banjoj Luci, 2014.

% definisi parametre 
conf = get_conf();
load(conf.desc_filename)

% racunanje standardne devijacije deskriptora
all_features = cat(1,features{:});
alpha = std(cat(1, all_features.desc));

precision = zeros(100, 1000);
recall = zeros(100, 1000);
ap = zeros(100, 1);
rel = zeros(1, 1000);

n = 0;
for k = 118:118
    % odrediti deskriptor upita
    [foo, filename] = fileparts(features{k}.filename);
    
    if str2double(filename) >= 0 && str2double(filename) < 1000
        query = features{k}.desc;
        
        % Pretrazivanje baze. Racuna se udaljenost deskriptora svake slike iz baze
        % od deskriptora upita.
%         dist = compute_histogram_intersection(query, features);
        dist = compute_l1_distances(query, features, alpha);
        
        % Sortiranje udaljenosti u rastucem redoslijedu. U nizu sorted su
        % sortirane vrijednosti udaljenosti, a u nizu ind su indeksi elemenata u
        % originalnom nizu.
        [sorted, ind] = sort(dist);
        
        for m = 1:1000
            [foo, imname] = fileparts(features{ind(m)}.filename);
            rel(m) = floor(str2double(imname)/100) == floor(str2double(filename)/100);
        end
        n = n + 1;
        precision(n, :) = cumsum(rel)./(1:1000);
        recall(n, :) = cumsum(rel)/100;
        ap(n) = sum(precision(n, :) .* rel) / 100;
    end
end
figure, plot(mean(recall), mean(precision));
map = mean(ap);
xlabel('Recall'); ylabel('Precision'); title(['MAP = ' num2str(map)]);

