function chist = compute_color_histogram(im, conf)
% Izracunava kolor-histogram za sliku im i kvantizaciju prostora datu u
% conf

im = im2double(im);
im_quant = zeros(size(im));

% kvantizacija boja
q = 1 ./ conf.qlevels;

for c = 1:3
%     Kvantizacija je ovdje, ali...
%     Akrobacija sluzi da se maksimalna vrijednost ukljuci u zadnji nivo
%     im_quant(:, :, c) = fix(im(:, :, c)/q(c) - 0.5) * q(c);
%     nama trebaju samo indeksi koji pocinju od 1
    im_quant(:, :, c) = fix(im(:, :, c)/q(c) - 0.5) + 1;
end

im_quant = reshape(im_quant, [size(im_quant, 1) * size(im_quant, 2), 3]);

chist = accumarray(im_quant, 1, conf.qlevels);
chist = reshape(chist, 1, []);
