function desc = gabor_descriptor_grayscale(im, conf)
% izracunava Gaborov deskriptor teksture za datu sliku

GW = conf.GW;
N = conf.N;
scales = conf.scales;
orientations = conf.orientations;

im0 = rgb2gray(im);
A = fft2(im0, N, N);
C = zeros(N*scales, N*orientations);

desc = zeros(scales*orientations, 2);
for s = 1:scales,
    for n = 1:orientations,
        B = A .* GW(N*(s-1)+1:N*s, N*(n-1)+1:N*n);
        D = ifft2(B);
        C(N*(s-1)+1:N*s, N*(n-1)+1:N*n) = D;
        desc(orientations*(s-1)+n, :) = [mean2(abs(D)) std2(abs(D))];
    end
end

desc = reshape(desc, 1, numel(desc));
