% Spam/ham klasifikator, glavni program

%% Formiraj model
conf = get_conf();
vocab = generate_vocabulary(conf);
[training_set, training_C, test_set, test_C] = ...
    compute_collection_representation(vocab, conf);

%% SVM klasifikator
model = svmtrain(training_C, training_set, '-t 0 -c 1');
[predict_label_svm, accuracy, prob_est] = svmpredict(test_C, test_set, model);

acc_svm = sum(predict_label_svm == test_C) / length(test_C)

cm_svm = conf_mat(predict_label_svm, test_C, 2)

%% kNN klasifikator

predict_label_nn = apply_knn(training_set, training_C, test_set);

acc_nn = sum(predict_label_nn == test_C) / length(test_C)

cm_nn = conf_mat(predict_label_nn, test_C, 2)

%% multinomni Bayesov klasifikator

% multinomial_model = train_multinomial_nb(vocab, conf);
% predict_label_multinomial_nb = apply_multinomial_nb(vocab, multinomial_model, conf);
% 
% acc_mnb = sum(predict_label_multinomial_nb == test_C) / length(test_C)
% 
% cm_mnb = conf_mat(predict_label_multinomial_nb, test_C, 2)

%% Bernoulli Bayesov klasifikator

% bernoulli_model = train_bernoulli_nb(vocab, conf);
% predict_label_bernoulli_nb = apply_bernoulli_nb(vocab, bernoulli_model, conf);
% 
% acc_bnb = sum(predict_label_bernoulli_nb == test_C) / length(test_C)
% 
% cm_bnb = conf_mat(predict_label_bernoulli_nb, test_C, 2)
